package com.example.sefinsa_app.ui.folios.ver;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;

import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;

import com.example.sefinsa_app.R;

/**
 * A simple {@link Fragment} subclass.
 * Use the {@link VerFirmasFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class VerFirmasFragment extends DialogFragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    private String mParam1;
    private String mParam2;

    public VerFirmasFragment() { }

    public static VerFirmasFragment newInstance(String param1, String param2) {
        VerFirmasFragment fragment = new VerFirmasFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (getDialog() != null && getDialog().getWindow() != null) {
            int width = (int) (getResources().getDisplayMetrics().widthPixels * 0.9); // 90% de la pantalla
            int height = ViewGroup.LayoutParams.WRAP_CONTENT;
            getDialog().getWindow().setLayout(width, height);
        }
    }


    ImageView imgFirmaUsuario;
    ImageView imgFirmaCliente;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View view = inflater.inflate(R.layout.fragment_ver_firmas, container, false);

        imgFirmaCliente = view.findViewById(R.id.imgFirmaCliente);
        imgFirmaUsuario = view.findViewById(R.id.imgFirmaUsuario);

        SharedPreferences p = requireActivity().getSharedPreferences("firmas", Context.MODE_PRIVATE);

        String firmaUsuario = p.getString("firmaUsuario", null);
        if (firmaUsuario != null) {
            byte[] decodedBytes = Base64.decode(firmaUsuario, Base64.DEFAULT);
            Bitmap bitmap = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
            imgFirmaUsuario.setImageBitmap(bitmap);
        } else {
            Log.d("firmas", "onCreateView: usuario");
        }

        String firmaCliente = p.getString("firmaCliente", null);
        if (firmaCliente != null) {
            byte[] decodedBytes = Base64.decode(firmaCliente, Base64.DEFAULT);
            Bitmap bitmap = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
            imgFirmaCliente.setImageBitmap(bitmap);
        } else {
            Log.d("firmas", "onCreateView: cliente");
        }

        Button btnCerrar = view.findViewById(R.id.btnCerrar);
        btnCerrar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });


        return view;
    }
}